package fr.asip.cps3.exemple.vues.ecrans.saisie;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagLayout;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EmptyBorder;

import fr.asip.cps3.exemple.vues.FenetrePrincipale;
import fr.asip.cps3.exemple.vues.composants.GridBagHelper;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;

/**
 * Classe permettant de modliser l'cran de saisie d'un PIN
 */
public class Saisie1PIN extends Saisie {

	/**
	 * Libell PIN 
	 */
	protected JLabel libellePIN;

	/**
	 * Libell statut PIN 
	 */
	protected JLabel statutPIN;	
	
	/**
	 * Texte PIN
	 */
	protected JPasswordField textePIN;
	
	/**
	 * Constructeur  2 arguments
	 * @param fenetre La fentre qui doit contenir l'cran de saisie
	 * @param typeEcran Type d'cran
	 */
	public Saisie1PIN(FenetrePrincipale fenetre,int typeEcran) {
		this(fenetre,typeEcran,"Entrez le code porteur :");
	}

	/**
	 * Constructeur  3 arguments
	 * @param fenetre La fentre qui doit contenir l'cran de saisie
	 * @param typeEcran Type d'cran
	 * @param libelle Libell du champ PIN
	 * 
	 */
	public Saisie1PIN(FenetrePrincipale fenetre,int typeEcran,String libelle) {

		super(fenetre,typeEcran);
		libellePIN = new JLabel(libelle);
		textePIN = new JPasswordField(32);
    	
	}	

	/**
	 * Constructeur  4 arguments
	 * @param fenetre La fentre qui doit contenir l'cran de saisie
	 * @param typeEcran Type d'cran
	 * @param libelle Libell du champ PIN
	 * @param statutPIN Libell statut PIN
	 * 
	 */
	public Saisie1PIN(FenetrePrincipale fenetre,int typeEcran,String libelle,String statutPIN) {

		super(fenetre,typeEcran);
		libellePIN = new JLabel(libelle);
		textePIN = new JPasswordField(32);
		this.statutPIN = new JLabel(statutPIN);
		this.statutPIN.setFont(new Font("Arial",Font.ITALIC,11));
		this.statutPIN.setForeground(Color.RED);
    	
	}	
	
	/**
     * Renvoie le code PIN
     * @return Code PIN
     */
	public char[] getPIN() {
		if(textePIN != null)
			return textePIN.getPassword();
		else return null;
	}

	/**
	 * Affiche les champs d'entre
	 */
    public void affiche() {

    	JFrame fenetre = this.fenetre.getFenetre();
    	
    	if(fenetre != null && fenetre.getContentPane() != null) {
    	
	    	EcranUtil.supprimeTousLesComposants(((JPanel)fenetre.getContentPane()));
	    	
	        // Cration du layout
	    	((JPanel)fenetre.getContentPane()).setBorder(new EmptyBorder(0, 0, 0, 0));
	        GridBagLayout layout = new GridBagLayout();
	        ((JPanel)fenetre.getContentPane()).setLayout(layout);
	        
	        // Ajout des composants
	        GridBagHelper g = new GridBagHelper(fenetre.getContentPane());
	        // Ligne 0
	        g.ajoute(libellePIN, EcranUtil.styleLibelleSaisie, 0, 0, 1, 1);
	        g.ajoute(textePIN, EcranUtil.styleChampTexteSaisie, 0, 1, 1, 1);
	        if(statutPIN != null)
	        	g.ajoute(statutPIN, EcranUtil.styleLibelleStatutPIN, 0, 2, 1, 1);
	        // Ligne 1
	        if(statutPIN != null)
	        	g.ajoute(soumettre, EcranUtil.styleBoutonSoumettre, 1, 0, 1, 3);
	        else
	        	g.ajoute(soumettre, EcranUtil.styleBoutonSoumettre, 1, 0, 1, 2);
	        // Ligne 2
	        if(statutPIN != null)
	        	g.ajoute(barreStatut, EcranUtil.styleBarreStatut, 2, 0, 1, 3);
	        else
	        	g.ajoute(barreStatut, EcranUtil.styleBarreStatut, 2, 0, 1, 2);
	        
    	}
    }
}
